<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <title>abd.ro de vanzare</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-alpha.6/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.min.css">
        <link href="https://fonts.googleapis.com/css?family=Mukta+Mahee:300,700" rel="stylesheet">
        <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css" />
        <link rel="stylesheet" href="css/style.css" />
        <script src="https://www.google.com/recaptcha/api.js?render=site_key"></script>

    </head>
    <body>

        <section class="bg-alt hero p-0">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-6 bg-faded text-center col-fixed">
                        <div class="vMiddle">
                          <h1 class="pt-4 h2">
                              <span class="text-green">abd.ro</span>
                              <small>Disponibil pentru vânzare</small>
                          </h1>
                          <p class="mt-4">
                              Pentru cumpărare instantanee. Vă rugăm să faceți o comandă.
                          </p>
                          <div class="pt-5">
                              <label for="name">
                              <a class="btn text-white bg-green btn-lg">Faceți o ofertă!</a>
                              </label>
                          </div>

                      </div>
                    </div>
                    <div class="col-sm-6 offset-sm-6">
                        <section class="bg-alt">
                            <div class="container">
                                <div class="row height-100">
                                    <div class="col-sm-10 offset-sm-1 mt-2">
                                        <form id="main-offer-form" action="contact.php" method="post">
                                            <h2 class="text-primary">Sunteți interesați de acest domeniu?</h2>
                                            <hr/>
                                            <div class="form-group">
                                                <input
                                                  type="text"
                                                  name="name"
                                                  id="name"
                                                  class="form-control"
                                                  placeholder="Nume Complet (Obligatoriu)"
                                                >
                                            </div>
                                            <div class="row">
                                              <div class="col">
                                                <div class="form-group">
                                                    <input
                                                      type="email"
                                                      name="email"
                                                      class="form-control"
                                                      placeholder="Email (Obligatoriu)"
                                                    >
                                                </div>
                                              </div>
                                              <div class="col">
                                                <div class="form-group">
                                                    <input
                                                      type="text"
                                                      name="phone"
                                                      class="form-control"
                                                      placeholder="Numar de telefon (Obligatoriu)"
                                                    >
                                                </div>
                                              </div>
                                            </div>
                                            <div class="form-group">
                                                <input
                                                  type="number"
                                                  name="price"
                                                  class="form-control"
                                                  min="0"
                                                  placeholder="Oferta de pret in EUR? (Obligatoriu)">
                                            </div>
                                            <div class="form-group">
                                                <textarea name="comments" class="form-control" placeholder="Mesaj (optional)"></textarea>
                                            </div>
                                            
                                             
           <div class="g-recaptcha" data-sitekey="6LehhEEnAAAAALv0ns2Ir2tCTA67awlmfP01xp3P"></div>
<br>

                                            <button  type="submit" class="btn text-white btn-lg bg-primary btn-block" >Faceți o ofertă</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </section>
                    </div>
                </div>
            </div>
        </section>
        <script src="js/jquery.min.js"></script>
        <script src="js/jquery.validate.min.js"></script>
        <script>
          $( "#main-offer-form" ).validate({
            errorClass: 'form-control-feedback',
            errorElement: 'div',
            highlight: function(element) {
              $(element).parents(".form-group").addClass("has-danger");
            },
            unhighlight: function(element) {
              $(element).parents(".form-group").removeClass("has-danger");
            },
            rules: {
                name: 'required',
                email: {
                  required: true,
                  email: true
                },
                phone: {
                  required: true,
                  minlength:10,
                  maxlength:10
                },
                price: "required",
                comments: {
                  maxlength: 500
                }
              },
              messages: {
                name: 'Please enter your name.',
                email: {
                  required: 'You can not leave this empty.',
                  email: 'Please enter a valid email address.'
                },
                phone: {
                  required: 'You can not leave this empty.',
                  matches: 'Please enter a valide phone number.',
                  minlength: 'Phone number should be min 10 digits.',
                  maxlength: 'Phone number should be max 10 digits.'
                },
                price: {
                  price: 'Please enter offered price.'
                },
                comments: {
                  maxlength: 'Message length must be less than 500 character.'
                }
              }
          });
        </script>
        
      

    </body>
</html>
